package gov.va.vamf.scheduling.direct.exception;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class VARExceptionMapper extends Throwable implements ExceptionMapper<Throwable> {

    private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(VARExceptionMapper.class);

    @Override
    public Response toResponse(Throwable ex) {
        logger.error("Unhandled exception", ex);

        if (ex instanceof WebApplicationException) {
            return ((WebApplicationException)ex).getResponse();
        }

        return Response.status(Response.Status.INTERNAL_SERVER_ERROR)
            .entity("Request has failed")
            .type(MediaType.APPLICATION_JSON)
            .build();
    }
}
